var finesse = finesse || {};
finesse.gadget = finesse.gadget || {};
finesse.container = finesse.container || {};
clientLogs = finesse.cslogger.ClientLogger || {};  // for logging

/** @namespace */
finesse.modules = finesse.modules || {};
finesse.modules.ScreenRecordingGadget = (function ($) {
    var user, dialogs, clientlogs,
    
    /**
     * Make a REST API request and send the response to the success or error
     * handler depending on the HTTP status code
     *
     * @param {String} url
     *     The unencoded URL to which the request is sent (will be encoded)
     * @param {Object} options
     *     An object containing additional options for the request.
     *
     *     {String} options.method
     *        The type of request (e.g. GET, PUT, POST, DELETE)
     *     {String} options.authorization
     *        [Optional] The authorization string for the request
     *     {String} options.contentType
     *        [Optional] The Content-Type of the request (e.g. application/json,
     *                   application/xml)
     *     {String} options.content
     *        A string to send in the content body of the request.
     * @param {Object} handlers
     *     An object containing the success and error handlers.
     *
     *     {Function} handlers.success(response)
     *        A callback function to be invoked for a successful request.
     *     {Function} handlers.error(response)
     *        A callback function to be invoked for an unsuccessful request.
     */
    makeRequest = function (url, options, handlers) {
        var params, uuid;
        clientLogs.log("makeRequest()");
        
        // Protect against null dereferencing of options & handlers allowing its (nonexistant) keys to be read as undefined
        params = {};
        options = options || {};
        handlers.success = _util.validateHandler(handlers.success);
        handlers.error = _util.validateHandler(handlers.error);

        // Request Headers
        params[gadgets.io.RequestParameters.HEADERS] = {};

        // HTTP method is a passthrough to gadgets.io.makeRequest
        params[gadgets.io.RequestParameters.METHOD] = options.method;

        if (options.method === "GET") {
            // Disable caching for GETs
            if (url.indexOf("?") > -1) {
                url += "&";
            } else {
                url += "?";
            }
            url += "nocache=" + _util.currentTimeMillis();
        } else {
            // Generate a requestID and add it to the headers
            uuid = _util.generateUUID();
            params[gadgets.io.RequestParameters.HEADERS].requestId = uuid;
            params[gadgets.io.RequestParameters.GET_FULL_HEADERS] = "true";
        }
        
        // Add authorization to the request header if provided
        if(options.authorization) {
            params[gadgets.io.RequestParameters.HEADERS].Authorization = options.authorization;
        }

        // Add content type & body if content body is provided
        if (options.content) {
            // Content Type
            params[gadgets.io.RequestParameters.HEADERS]["Content-Type"] = options.contentType;
            // Content
            params[gadgets.io.RequestParameters.POST_DATA] = options.content;
        }

        // Call the gadgets.io.makereqest function with the encoded url
        clientLogs.log("makeRequest(): Making a REST API request to: " + url);
       // gadgets.io.makeRequest(encodeURI(url), handleResponse(handlers), params);
	var httpRequest = new XMLHttpRequest();
        httpRequest.onreadystatechange = function() { if (httpRequest.readyState == XMLHttpRequest.DONE) {
        clientLogs.log(httpRequest.responseText);} };
        httpRequest.open("GET",url, true);
        httpRequest.send(null);


    },
    
    /**
     * Handler for the response of the REST API request. This function determines if
     * the success or error handler should be called based on HTTP status code.
     *
     * @param {Object} handlers
     *     An object containing the success and error handlers.
     *
     *     {Function} handlers.success(response)
     *        A callback function to be invoked for a successful request.
     *     {Function} handlers.error(response)
     *        A callback function to be invoked for an unsuccessful request.
     */
    handleResponse = function(handlers) {
        return function (response) {
            clientLogs.log("handleResponse(): The response status code is: " + response.rc);
            
            // Send the response to the success handler if the http status
            // code is 200 - 299. Send the response to the error handler
            // otherwise.
            if (response.rc >= 200 && response.rc < 300 && handlers.success) {
                clientLogs.log("handleResponse(): Got a successful response.");
                handlers.success(response);
            } else if (handlers.error) {
                clientLogs.log("handleResponse(): Got a failure response.");
                handlers.error(response);
            } else {
                clientLogs.log("handleResponse(): Missing the success and/or error handler.");
            }
        };
    },
    
    /**
     * Handler for when the REST API response has a HTTP status code >= 200 and < 300.
     *
     * @param {Object} response
     *     An object containing the HTTP response.
     */
    handleResponseSuccess = function(response) {
        clientLogs.log("handleResponseSuccess():");
        // Parse the response text to JSON format
        // var responseTextJSON = JSON.parse(response.text);
        
        // Update the gadget with the response text (unformatted)
        $("#responseBody").text(response.text);
        gadgets.window.adjustHeight();
    },
    
    /**
     * Handler for when the REST API response has a HTTP status code < 200 and >= 300. 
     *
     * @param {Object} response
     *     An object containing the HTTP response.
     */
    handleResponseError = function(response) {
        clientLogs.log("handleResponseError():");
        $("#responseBody").text("Something went wrong with the REST call.");
        gadgets.window.adjustHeight();
    },
    
    /**
     * Handle when the dialog object is updated/changed
     */
   _processCall = function (dialog) {
           clientLogs.log("_processCall()");

           let data = dialog._data
           let config = dialog._config
           let ext = config.extension
           let device = config.id
           let dialogId =  data.id
           let fromAddress =  data.fromAddress
           let mediaProperty = data.mediaProperties
           let DNIS = mediaProperty.DNIS
           let state = data.state

           if(state == "ACTIVE"){
                   console.log("Call State is = " + state)
                   console.log(dialog)
                   console.log(data)
                   console.log(mediaProperty)

                   // Call the REST API and display the results
                   var url = "http://localhost:8000/start?DNIS="+DNIS+"&dialogId="+dialogId+"-"+ext+"&extension="+ext+"&device="+device;

                   //var contentBody = "<User><state>READY</state></User>";
                   makeRequest(url, {
                           method: 'GET',
                           // authorization: _util.getAuthHeaderString(finesse.gadget.Config),
                           // contentType: 'application/xml',
                           // content: contentBody,
                   }, {
                    success: handleResponseSuccess,
                   error: handleResponseError,
                   });

            }
         },

    /**
     *  Handler for additions to the Dialogs collection object. This will occur when a new
     *  Dialog is created on the Finesse server for this user.
     */


      handleNewDialog = function(dialog) {
             clientLogs.log("handleNewDialog()");

             // add a handler to be called when the dialog object changes
             dialog.addHandler('change', _processCall);
            },

  endCall = function(dialog){
                  let state = dialog._data.state
                  console.log("Call State is now = " + state);
        }
     
    /**
     *  Handler for deletions from the Dialogs collection object for this user. This will occur
     *  when a Dialog is removed from this user's collection (example, end call)
     */
    handleEndDialog = function(dialog) {
            clientLogs.log("handleEndDialog()");
            console.log("handleEndDialog() Finesse Api is about to be Called /STOP");


            let data = dialog._data
            let dialogId =  data.id
            let config = dialog._config
            let ext = config.extension
            let fromAddress =  data.fromAddress
            let mediaProperty = data.mediaProperties
            let DNIS = mediaProperty.DNIS

           //var url = "REST API and display the results"
           var url = "http://localhost:8000/stop?DNIS="+DNIS+"&dialogId="+dialogId+"-"+ext;
            //var contentBody = "<User><state>READY</state></User>";
            makeRequest(url, {
                method: 'GET',
                //authorization: _util.getAuthHeaderString(finesse.gadget.Config),
                //contentType: 'application/xml',
                //content: contentBody,
            }, {
                success: handleResponseSuccess,
                error: handleResponseError,
            });

            dialog.addHandler('change', endCall);
            // Update the gadget accordingly
            $("#responseBody").text("Please wait for a call.");
            gadgets.window.adjustHeight();
        },

    /**
     * Handler for the onLoad of a User object. This occurs when the User object is initially read
     * from the Finesse server. Any once only initialization should be done within this function.
     */
    handleUserLoad = function (userevent) {
        clientLogs.log("handleUserLoad()");
        // Get an instance of the dialogs collection and register handlers for dialog additions and
        // removals
        dialogs = user.getDialogs( {
            onCollectionAdd : handleNewDialog,
            onCollectionDelete : handleEndDialog
        });
        
        // Set the text on the gadget to be something default
        $("#responseBody").text("Please wait for a call.");
        gadgets.window.adjustHeight();
    },
      
    /**
     *  Handler for all User updates
     */
    handleUserChange = function(userevent) {
        clientLogs.log("handleUserChange()");
	console.log("handleUserChange()");
    };

    /** @scope finesse.modules.ScreenRecordingGadget */
    return {
        /**
         * Performs all initialization for this gadget
         */
        init : function () {
		console.log("hello");
            var cfg = finesse.gadget.Config;
            _util = finesse.utilities.Utilities;

            clientLogs = finesse.cslogger.ClientLogger;  // declare clientLogs

            // Initiate the ClientServices and load the user object. ClientServices are
            // initialized with a reference to the current configuration.
            finesse.clientservices.ClientServices.init(cfg, false);

            // Initiate the ClientLogs. The gadget id will be logged as a part of the message
            clientLogs.init(gadgets.Hub, "ScreenRecordingGadget");
            console.log(gadgets.Hub, "ScreenRecordingGadget console log");
            // Create a user object for this user (Call GET User)
            user = new finesse.restservices.User({
                id: cfg.id, 
                onLoad : handleUserLoad,
                onChange : handleUserChange
            });
            
            // Initiate the ContainerServices and add a handler for when the tab is visible
            // to adjust the height of this gadget in case the tab was not visible
            // when the html was rendered (adjustHeight only works when tab is visible)
            containerServices = finesse.containerservices.ContainerServices.init();
            containerServices.addHandler(finesse.containerservices.ContainerServices.Topics.ACTIVE_TAB, function() {
            clientLogs.log("Gadget is now visible");  // log to Finesse logger
		    clientLogs.log("Gadget is now visible Client Logs");
            console.log("Gadget is now visible console log");
	        // Automatically adjust the height of the gadget to show the html
            gadgets.window.adjustHeight();
            });
            containerServices.makeActiveTabReq();
        }
    };
}(jQuery));
